<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to the GNU General Public License v3.0
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@smartsend.io so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade the plugin to newer
 * versions in the future. If you wish to customize the plugin for your
 * needs please refer to https://www.smartsend.io
 *
 * @author    Smart Send <support@smartsend.io>
 * @copyright Smart Send
 * @license   http://www.gnu.org/licenses/gpl-3.0.html  GNU General Public License v3.0
 */

class SmartSendAgentClass extends ObjectModel
{
    /** @var integer shipping method agent id */
    public $id;

    /** @var integer shipping method id_carrier */
    public $id_carrier;

    /** @var integer cart id */
    public $cart_id;

    /** @var integer order id */
    public $order_id;

    /** @var string store */
    public $store;

    /** @var integer agent number */
    public $agent_no;

    /** @var string company */
    public $company;

    /** @var string address_line1 */
    public $address_line1;

    /** @var string address_line2 */
    public $address_line2;

    /** @var string city */
    public $city;

    /** @var integer postal_code */
    public $postal_code;

    /** @var string country */
    public $country;


    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table'   => 'smartsend_agent',
        'primary' => 'id',
        'fields'  => array(
            'id_carrier'      => array(
                'type'     => self::TYPE_INT,
                'required' => true,
            ),
            'cart_id'      => array(
                'type'     => self::TYPE_INT,
                'required' => true,
            ),
            'order_id'      => array(
                'type'     => self::TYPE_INT,
            ),
            'store' => array(
                'type' => self::TYPE_STRING,
            ),
            'agent_no'      => array(
                'type'     => self::TYPE_INT,
                'required' => true,
            ),
            'company' => array(
                'type' => self::TYPE_STRING,
                'required' => true,
            ),
            'address_line1' => array(
                'type' => self::TYPE_STRING,
                'required' => true,
            ),
            'address_line2' => array(
                'type' => self::TYPE_STRING,
            ),
            'city' => array(
                'type' => self::TYPE_STRING,
                'required' => true,
            ),
            'postal_code'      => array(
                'type'     => self::TYPE_INT,
                'required' => true,
            ),
            'country' => array(
                'type' => self::TYPE_STRING,
                'required' => true,
            ),
        ),
    );

    public function copyFromPost($data)
    {
        /* Classical fields */
        foreach ($data as $key => $value) {
            if (array_key_exists($key, $this) and $key != 'id_' . $this->table) {
                $this->{$key} = $value;
            }
        }
    }

    public function getAgentDetailsByOrderId($order_id)
    {
        $sql = 'SELECT * FROM `' . _DB_PREFIX_ . 'smartsend_agent`
            WHERE order_id = ' . (int)$order_id . ' ORDER BY id DESC';
        
        return Db::getInstance()->getRow($sql);
    }

    public function getAgentDetailsByCartId($cart_id)
    {
        $sql = 'SELECT * FROM `' . _DB_PREFIX_ . 'smartsend_agent`
            WHERE cart_id = ' . (int)$cart_id . ' ORDER BY id DESC';
        
        return Db::getInstance()->getRow($sql);
    }

    public function deleteAgentDetails($cart_id)
    {
        $sql = 'DELETE FROM `' . _DB_PREFIX_ . 'smartsend_agent`
            WHERE cart_id = ' . (int)$cart_id . ' ORDER BY id DESC';
        
        return Db::getInstance()->execute($sql);
    }
}
