<?php
/**
 * LICENSE
 *
 * This source file is subject to the GNU General Public License v3.0
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@smartsend.io so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade the plugin to newer
 * versions in the future. If you wish to customize the plugin for your
 * needs please refer to https://www.smartsend.io
 *
 * @author      Smart Send ApS
 * @copyright   Copyright (c) Smart Send ApS (https://www.smartsend.io)
 * @license     https://smartsend.io/license
 * @url         https://smartsend.io/
 * @class       SmartSendShippingApi
 * @folder      smartsend/classes/class.api.php
 *
 */

include_once _PS_MODULE_DIR_ . 'smartsend/lib/Smartsend/Api.php';

class SmartSendShippingApi extends Module
{
    protected $defaultGatewayURL = 'https://app.smartsend.io/track/';

    protected $api_handle;

    public function __construct($apiToken=null, $demoMode=null, $website=null)
    {
        if (!$apiToken) {
            $apiToken = Configuration::get('SMARTSEND_API_TOKEN', null);
        }

        if (!$demoMode) {
            $demoMode = !Configuration::get('SMARTSEND_LIVE_MODE', null);
        }

        if (!$website) {
            $website = parse_url(_PS_BASE_URL_, PHP_URL_HOST);
        }

        $this->api_handle = new \Smartsend\Api($apiToken, $website, $demoMode);
        parent::__construct();
    }

    public function getErrorString()
    {
        return $this->api_handle->getErrorString();
    }


    public function getDefaultTrackingGateway()
    {
        return $this->defaultGatewayURL;
    }

    public function setApiToken($api_token)
    {
        $this->api_handle->setApiToken($api_token);
    }

    public function setDemo($demo)
    {
        $this->api_handle->setDemo($demo);
    }

    public function generateShippingLabel($shipment)
    {
        $response = array();
        // Send the shipment object. The new object will be almost identical, but will have 'id' and 'type' fields
        if ($this->api_handle->createShipmentAndLabels($shipment)) {
            $response['data'] = $this->api_handle->getData();
        } else {
            //fetch error:
            $response['error'] = $this->api_handle->getErrorString();
        }
        return $response;
    }

    public function combineLabelsForShipments($array_shipment_ids)
    {
        $this->api_handle->combineLabelsForShipments($array_shipment_ids);
        return $this->api_handle;
    }

    public function getAgentPoints($carriers, $country, $postal_code, $city, $street)
    {
        $response = array();
        if ($this->api_handle->findClosestAgentByAddress($carriers, $country, $postal_code, $city, $street)) {
            $response['data'] = $this->api_handle->getData();
        } else {
            //fetch error:
            $response['error'] = $this->api_handle->getErrorString();
        }
        return $response;
    }

    public function validateToken()
    {
        return $this->api_handle->getAuthenticatedUser();
    }
}
