<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to the GNU General Public License v3.0
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@smartsend.io so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade the plugin to newer
 * versions in the future. If you wish to customize the plugin for your
 * needs please refer to https://www.smartsend.io
 *
 * @author    Smart Send <support@smartsend.io>
 * @copyright Smart Send
 * @license   http://www.gnu.org/licenses/gpl-3.0.html  GNU General Public License v3.0
 */

include_once _PS_MODULE_DIR_ . 'smartsend/smartsendmethods.php';

class SmartsendShippingController extends AdminCarriersControllerCore
{
    public function __construct()
    {
        parent::__construct();
    }

    public function postProcess()
    {
        $data = array();
        if (Tools::getValue('action')) {
            $actiontemp = explode('_', Tools::getValue('action'));

            $method_name = Tools::getValue('value');
            $data['id_carrier'] = $carrier_id = $actiontemp[2];

            if ($carrier_id) {
                $smartsend_shipping = new SmartSendMethodsClass();
                if ($smartsend_shipping->getShippingMethodByCarrierId((int)$carrier_id)) {
                    $smartsend_shipping = new SmartSendMethodsClass(
                        $smartsend_shipping->getShippingMethodByCarrierId((int)$carrier_id)
                    );
                } else {
                    $smartsend_shipping = new SmartSendMethodsClass();
                }
            } else {
                $smartsend_shipping = new SmartSendMethodsClass();
            }
            if ($actiontemp[0] . '_' . $actiontemp[1] == 'shipping_method' && isset($method_name)) {
                $data['shipping_method'] = $method_name;
            } elseif ($smartsend_shipping->shipping_method) {
                $data['shipping_method'] = $smartsend_shipping->shipping_method;
            } else {
                $data['shipping_method'] = null;
            }
            if ($actiontemp[0] . '_' . $actiontemp[1] == 'return_method' && isset($method_name)) {
                $data['return_method'] = $method_name;
            } elseif ($smartsend_shipping->return_method) {
                $data['return_method'] = $smartsend_shipping->return_method;
            } else {
                $data['return_method'] = null;
            }
            $data['current_version'] = 0;

            $smartsend_shipping->copyFromPost($data);
            if ($smartsend_shipping->validateFields(false)) {
                $smartsend_shipping->save();
            }
            return true;
        }
    }
}
