{*
* NOTICE OF LICENSE
*
* This source file is subject to the GNU General Public License v3.0
* that is bundled with this package in the file license.txt.
* It is also available through the world-wide-web at this URL:
* http://www.gnu.org/licenses/gpl-3.0.html
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@smartsend.io so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade the plugin to newer
* versions in the future. If you wish to customize the plugin for your
* needs please refer to https://www.smartsend.io
*
*  @author    Smart Send <support@smartsend.io>
*  @copyright Smart Send
*  @license   http://www.gnu.org/licenses/gpl-3.0.html  GNU General Public License v3.0
*}

<div class="panel">
	<h3><i class="icon icon-truck"></i> {l s='Smart Send' mod='smartsend'}</h3>
	<img src="{$module_dir|escape:'html':'UTF-8'}/logo.png" id="payment-logo" class="pull-right" />
	<p>
		<strong>{l s='Connect your webshop to Smart Send!' mod='smartsend'}</strong><br />
		{l s='Create shipping labels directly from the backend.' mod='smartsend'}<br />
		{l s='Let your customers chose amongst the closest pick-up points during checkout.' mod='smartsend'}
	</p>
	<br />
	<p>	
		{l s='This module will boost your sales and save you precious time!' mod='smartsend'}
	</p>
</div>

<div class="panel">
	<h3><i class="icon icon-tags"></i> {l s='Documentation' mod='smartsend'}</h3>
	<p>
		&raquo; {l s='See detailed guides here' mod='smartsend'} :
		<ul>
			<li><a href="https://smartsend.io/prestashop/configuration" target="_blank">{l s='Configuration guide' mod='smartsend'}</a></li>
			<li><a href="https://smartsend.io/prestashop/api-token" target="_blank">{l s='Connect with API Token' mod='smartsend'}</a></li>
		</ul>
	</p>
</div>
<div class="loader_container">
	<div class="loader">
		<img src="{$module_dir|escape:'html':'UTF-8'}/views/img/ajax_loader.gif" id="ajax_loader" class="ajax_loader" />
	</div>
</div>
<script type="text/javascript">
$(document).on('change', '.return_method, .shipping_method', function() {
    var val = $(this).val();
    var id 	= $(this).attr('name');
    var url = '{$ajax_url|escape:'javascript':'UTF-8'}';
	$('.loader_container').show();
    $.ajax({
        url : url,
        cache : false,
        type : 'POST',
        data : {
            ajax: true,
            action: id,
            value: val
        },
        success : function(result) {
			$('.loader_container').hide();
        }
    });
});
</script>
<style type="text/css">
	.loader_container {
		display: none;
		position: fixed;
		width: 100%;
		height: 100%;
		top: 0;
		left: 0;
		background: #a79a9a2b;
		z-index: 5555;
	}
	.loader {
		position: absolute;
		left: 50%;
		top: 50%;
	}
	.ajax_loader {
		width: 50px;
		height: 50px;
		position: relative;
		display: block;
	}
</style>