<?php
/**
 * LICENSE
 *
 * This source file is subject to the GNU General Public License v3.0
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@smartsend.io so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade the plugin to newer
 * versions in the future. If you wish to customize the plugin for your
 * needs please refer to https://www.smartsend.io
 *
 * @author      Smart Send ApS
 * @copyright   Copyright (c) Smart Send ApS (https://www.smartsend.io)
 * @license     https://smartsend.io/license
 * @url         https://smartsend.io/
 * @class       SmartsendLabelController
 * @folder      smartsend/controllers/admin/SmartsendLabelController.php
 *
 */

class SmartsendCombineLabelController extends ModuleAdminController
{

    protected $shipment_ids = array();

    public function __construct($array_shipment_ids)
    {
        $this->shipment_ids = $array_shipment_ids;

        parent::__construct();
    }

    /**
     * Do rate request and handle errors
     *
     * @return array contains data-field if successful and errors if failed
     */
    public function combineLabelsForShipments()
    {
        include_once _PS_MODULE_DIR_ . 'smartsend/classes/class.api.php';
        $smartsend_api = new SmartSendShippingApi();
        return $smartsend_api->combineLabelsForShipments($this->shipment_ids);
    }

}
