{*
* LICENSE
*
* This source file is subject to the GNU General Public License v3.0
* that is bundled with this package in the file license.txt.
* It is also available through the world-wide-web at this URL:
* http://www.gnu.org/licenses/gpl-3.0.html
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@smartsend.io so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade the plugin to newer
* versions in the future. If you wish to customize the plugin for your
* needs please refer to https://www.smartsend.io
*
* @author 		Smart Send ApS
* @copyright	Copyright (c) Smart Send ApS (https://www.smartsend.io)
* @license		https://smartsend.io/license
* @url			https://smartsend.io/
* @folder		smart_send_shipping/views/templates/hook/carrier.tpl
*
*}

{if {$jquery_include}}
    <script type="text/javascript" src="//ajax.googleapis.com/ajax/libs/jquery/1.7.2/jquery.min.js"></script>
{/if}
<script type="text/javascript">
  $(document).ready(function() {
    var carrierId = '{$carrierId|escape:"htmlall":"UTF-8"}';
    {if {$jquery_include}}
        oldCell = $('input:radio#delivery_option_'+carrierId).closest('.delivery-option');
    {else}    
        if ($('input:radio[data-key="'+carrierId+',"]').closest('div.delivery_option.item').length > 0) {
            oldCell = $('input:radio[data-key="'+carrierId+',"]').closest('div.delivery_option.item');
        } else if ($('input:radio[data-key="'+carrierId+',"]').closest('div.delivery_option').length > 0) {
            oldCell = $('input:radio[data-key="'+carrierId+',"]').closest('div.delivery_option');
        } else {
            oldCell = $('input:radio[data-key="'+carrierId+',"]').closest('div.delivery_option.alternate_item');
        }
    {/if}
    {if {$pickup_available}}
        var dropdown_format = '{$dropdown_format|escape:"htmlall":"UTF-8"}';

        var pickup_points = [];
        {foreach $pickup_points as $item}
            var pickup_point = {};
            pickup_point['distance'] = '{$item["distance"]|escape:"htmlall":"UTF-8"}';
            pickup_point['agent_no'] = '{$item["agent_no"]|escape:"htmlall":"UTF-8"}';
            pickup_point['company'] = '{$item["company"]|escape:"htmlall":"UTF-8"}';
            pickup_point['address_line1'] = '{$item["address_line1"]|escape:"htmlall":"UTF-8"}';
            pickup_point['address_line2'] = '{$item["address_line2"]|escape:"htmlall":"UTF-8"}';
            pickup_point['city'] = '{$item["city"]|escape:"htmlall":"UTF-8"}';
            pickup_point['postal_code'] = '{$item["postal_code"]|escape:"htmlall":"UTF-8"}';
            pickup_point['country'] = '{$item["country"]|escape:"htmlall":"UTF-8"}';
            pickup_points.push(pickup_point);
        {/foreach}
        width = oldCell.width();
        
        select = document.createElement('select');
        select.name = 'shipping_agent_'+carrierId;
        select.id = 'shipping_agent_' + carrierId;
        select.className = 'form-control shipping_agents';
        dropdown_format = dropdown_format.split(',');
        
        var auto_select_pickup = '{$auto_select_pickup|escape:"htmlall":"UTF-8"}';
        
        $.each(pickup_points, function(key, val) {
            option = document.createElement('option');
            select.appendChild(option);
            option.value = JSON.stringify(val);
            if (key == 0 && auto_select_pickup) {
                option.selected = true;
            }
            var pickup_add = '';
            $.each(dropdown_format, function(index, value) {
                if (value.trim() === 'street') {
                    if (val.address_line1) {
                        pickup_add += val.address_line1+', ';
                    }
                    if (val.address_line2) {
                        pickup_add += val.address_line2+', ';
                    }
                } else if (value.trim()) {
                    pickup_add += val[value.trim()]+', ';
                }
            });
            var lastChar = pickup_add.slice(-2);
            if (lastChar == ', ') {
                pickup_add = pickup_add.slice(0, -2);
            }

            if (val.distance >= 1) {
                pickup_add = val.distance+'km: ' + pickup_add;
            } else if (val.distance > 0 && val.distance < 1) {
                pickup_add = (val.distance*1000)+'m: ' + pickup_add;
            }
            option.innerHTML = pickup_add;
        });
        option = document.createElement('option');
        select.prepend(option);
        if (!auto_select_pickup) {
            option.selected = true;
        }
        option.value = "";
        option.innerHTML = '{l s='Please select a pick-up point' mod='smartsend'}';
        option.disabled = true;
        newDiv = $('<div></div>').attr('class', 'shipping_agent_container').attr('id', 'shipping_agent_' + carrierId+ '_container').attr('style', 'display:none');
        newDiv.append(select);

        if (oldCell.find(jQuery('.shipping_agent_container')).length > 0) {
            oldCell.find(jQuery('.shipping_agent_container')).replaceWith(newDiv);
        } else {
            oldCell.append(newDiv); 
        }
    {else}
        newDiv = $('<div></div>').attr('class', 'shipping_agent_container').attr('id', 'shipping_agent_' + carrierId+ '_container').attr('style', 'display:none');
        newDiv.append('<span style="padding: 10px 15px;font-size: 15px;background: #fff;">{l s='Shipping to the closest pick-up point' mod='smartsend'}');
        
        if (oldCell.find(jQuery('.shipping_agent_container')).length > 0) {
            oldCell.find(jQuery('.shipping_agent_container')).replaceWith(newDiv);
        } else {
            oldCell.append(newDiv); 
        }
    {/if}
    {if {$jquery_include}}
        jQuery(".delivery-option input:radio").each(function(e) {
            if (jQuery(this).is(":checked")) {
                var carriedIds = jQuery(this).val();
                var carrierId = carriedIds.split(",")[0];
                jQuery("div#shipping_agent_" + carrierId + "_container").show();
                jQuery("div#shipping_agent_" + carrierId + "_container #shipping_agent_" + carrierId).attr("required", "true");
                jQuery("div#shipping_agent_" + carrierId + "_container").show();
            }
        });
    {else}
        jQuery("input.delivery_option_radio").each(function(e) {
            if (jQuery(this).is(":checked")) {
                var carriedIds = jQuery(this).val();
                var carrierId = carriedIds.split(",")[0];
                jQuery("div#shipping_agent_" + carrierId + "_container").show();
                jQuery("div#shipping_agent_" + carrierId + "_container #shipping_agent_" + carrierId).attr("required", "true");
                jQuery("div#shipping_agent_" + carrierId + "_container").show();
            }
        });
    {/if}
});
    
</script>