<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to the GNU General Public License v3.0
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@smartsend.io so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade the plugin to newer
 * versions in the future. If you wish to customize the plugin for your
 * needs please refer to https://www.smartsend.io
 *
 * @author    Smart Send <support@smartsend.io>
 * @copyright Smart Send
 * @license   http://www.gnu.org/licenses/gpl-3.0.html  GNU General Public License v3.0
 */

class SmartSendMethodsClass extends ObjectModel
{
    /** @var integer shipping method id */
    public $smethod_id;

    /** @var integer shipping method id */
    public $id_carrier;

    /** @var string shipping method */
    public $shipping_method;

    /** @var string return method */
    public $return_method;

    /** @var string shipping method current version */
    public $current_version;


    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table'   => 'smartsend_shipping',
        'primary' => 'smethod_id',
        'fields'  => array(
            'id_carrier'      => array(
                'type'     => self::TYPE_INT,
                'required' => true,
            ),
            'shipping_method' => array(
                'type' => self::TYPE_STRING,
            ),
            'return_method'   => array(
                'type' => self::TYPE_STRING,
            ),
            'current_version' => array(
                'type'     => self::TYPE_BOOL,
                'required' => true,
            ),
        ),
    );

    public function copyFromPost($data)
    {
        /* Classical fields */
        foreach ($data as $key => $value) {
            if (array_key_exists($key, $this) and $key != 'id_' . $this->table) {
                $this->{$key} = $value;
            }
        }
    }

    public function getShippingMethodByCarrierId($carrier_id)
    {
        $smethod_id = Db::getInstance()->getValue('SELECT `smethod_id` FROM `' . _DB_PREFIX_ . 'smartsend_shipping`
			WHERE id_carrier = ' . (int)$carrier_id . ' ORDER BY smethod_id DESC');
        if (!$smethod_id) {
            return false;
        } else {
            return $smethod_id;
        }
    }

    public function getAllShippingMethods()
    {
        $data = Tools::getAllValues();
        $filter = false;
        $filter_sql = null;
        if (isset($data['submitFiltercarrier']) && $data['submitFiltercarrier']) {
            $filtered_data = array();
            foreach ($data as $key => $value) {
                if (strpos($key, 'carrierFilter_') !== false && $value != null) {
                    $filtered_data[str_replace('carrierFilter_', '', $key)] = $value;
                    $filter = true;
                    if (is_numeric($value) && strpos($key, 'id_carrier') !== false) {
                        $filter_sql .= ' AND c.'.str_replace('carrierFilter_', '', $key).' = '.$value.' ';
                    } elseif (is_numeric($value) && strpos($key, 'current_version') !== false && $value == 0) {
                        $filter_sql .= '';
                    } elseif (is_numeric($value)) {
                        $filter_sql .= ' AND '.str_replace('carrierFilter_', '', $key).' = '.$value.' ';
                    } elseif (strpos($key, 'method') !== false) {
                        $filter_sql .= ' AND sm.'.str_replace('carrierFilter_', '', $key).' LIKE "%'.$value.'%" ';
                    } else {
                        $filter_sql .= ' AND '.str_replace('carrierFilter_', '', $key).' LIKE "%'.$value.'%" ';
                    }
                }
            }
        }
        $sql = 'SELECT c.*, sm.shipping_method, sm.return_method, sm.current_version, 
        cl.delay FROM `' . _DB_PREFIX_ . 'carrier` c 
        LEFT JOIN `' . _DB_PREFIX_ . 'carrier_lang` cl ON 
        (c.`id_carrier` = cl.`id_carrier` AND cl.`id_lang` = 1 AND cl.id_shop = 1 ) 
        LEFT JOIN `' . _DB_PREFIX_ . 'carrier_zone` cz ON (cz.`id_carrier` = c.`id_carrier`) 
        LEFT JOIN `' . _DB_PREFIX_ . 'smartsend_shipping` sm ON (c.`id_carrier` = sm.`id_carrier`) 
        INNER JOIN ' . _DB_PREFIX_ . 'carrier_shop carrier_shop ON 
        (carrier_shop.id_carrier = c.id_carrier';
        
        if (Context::getContext()->cookie->shopContext) {
            $shopContext = Context::getContext()->cookie->shopContext;
            $id_shop = explode('-', $shopContext);
            $sql .= ' AND carrier_shop.id_shop = '.$id_shop[1];
        }
        
        $sql .= ') WHERE c.`deleted` = 0 AND c.`active` = 1 AND (c.is_module = 0 OR c.need_range = 1)';
        if ($filter) {
            $sql .= $filter_sql;
        }
        $sql .= ' GROUP BY c.`id_carrier` ORDER BY c.`position` ASC';
        return Db::getInstance()->executeS($sql);
    }
}
