<?php
/**
 * NOTICE OF LICENSE
 *
 * This source file is subject to the GNU General Public License v3.0
 * that is bundled with this package in the file license.txt.
 * It is also available through the world-wide-web at this URL:
 * http://www.gnu.org/licenses/gpl-3.0.html
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@smartsend.io so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade the plugin to newer
 * versions in the future. If you wish to customize the plugin for your
 * needs please refer to https://www.smartsend.io
 *
 * @author    Smart Send <support@smartsend.io>
 * @copyright Smart Send
 * @license   http://www.gnu.org/licenses/gpl-3.0.html  GNU General Public License v3.0
 */

class SmartSendShipmentLabelsClass extends ObjectModel
{
    /** @var integer shipment label id */
    public $slabel_id;

    /** @var integer order id */
    public $order_id;

    /** @var string shipping method */
    public $shipping_method;

    /** @var string shipment label pdf link */
    public $pdf_link;

    /** @var string return shipment label pdf link */
    public $return_pdf_link;


    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table'   => 'smartsend_shipment_labels',
        'primary' => 'slabel_id',
        'fields'  => array(
            'order_id'        => array(
                'type'     => self::TYPE_INT,
                'required' => true,
            ),
            'shipping_method' => array(
                'type'     => self::TYPE_STRING,
                'required' => true,
            ),
            'pdf_link'        => array(
                'type'     => self::TYPE_STRING,
                'required' => false,
            ),
            'return_pdf_link' => array(
                'type'     => self::TYPE_STRING,
                'required' => false,
            ),
        ),
    );

    public function copyFromPost($data)
    {
        /* Classical fields */
        foreach ($data as $key => $value) {
            if (array_key_exists($key, $this) and $key != 'id_' . $this->table) {
                $this->{$key} = $value;
            }
        }
    }

    public function getShipmentLabelIdByOrderId($order_id, $shipping_method)
    {
        $slabel_id = Db::getInstance()->getValue('SELECT `slabel_id` FROM `' . _DB_PREFIX_ . 'smartsend_shipment_labels`
			WHERE order_id = ' . (int)$order_id . ' AND shipping_method = "' . $shipping_method . '" ORDER BY slabel_id DESC');
        if (!$slabel_id) {
            return false;
        } else {
            return $slabel_id;
        }
    }

    public function getShipmentLabelDetailsByOrderId($order_id)
    {
        $slabel_details = Db::getInstance()->getRow('SELECT * FROM `' . _DB_PREFIX_ . 'smartsend_shipment_labels`
			WHERE order_id = ' . (int)$order_id . ' ORDER BY slabel_id DESC');
        if (!$slabel_details) {
            return false;
        } else {
            return $slabel_details;
        }
    }
}
