{*
* LICENSE
*
* This source file is subject to the GNU General Public License v3.0
* that is bundled with this package in the file license.txt.
* It is also available through the world-wide-web at this URL:
* http://www.gnu.org/licenses/gpl-3.0.html
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@smartsend.io so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade the plugin to newer
* versions in the future. If you wish to customize the plugin for your
* needs please refer to https://www.smartsend.io
*
* @author 		Smart Send ApS
* @copyright	Copyright (c) Smart Send ApS (https://www.smartsend.io)
* @license		https://smartsend.io/license
* @url			https://smartsend.io/
* @folder		smartsend/views/templates/hook/content_ship.tpl
*
*}

{include file="./label_buttons.tpl"}<!--  label buttons of the order   -->

{if $is_pickup_method == true}
    <!-- Tab pickuppoint -->
	<div id="extraTabPickup">
		<div class="tab-pane d-print-block fade" id="agentDetailsTabContent" role="tabpanel" aria-labelledby="agentDetailsTab">
			<h4>{l s='Pick-up point' mod='smartsend'}</h4>
			{if  $agent_data['id'] != ''}
				{$agent_data['company']|escape:'html':'UTF-8'}<br><!-- Company -->
				{implode(" ", array_filter(array($agent_data['address_line1'], $agent_data['address_line2'])))|escape:'html':'UTF-8'}<br><!-- street -->
				{$agent_data['postal_code']|escape:'html':'UTF-8'} {$agent_data['city']|escape:'html':'UTF-8'}<br><!-- zip city -->
				{if $agent_data['country'] != ''}
					{Country::getNameById($id_lang,Country::getByIso($agent_data['country']))|escape:'html':'UTF-8'}<br><!-- country -->
				{/if}
			{else}
				{l s='Shipping to closest pick-up point' mod='smartsend'}
			{/if}
		</div>
	</div>
    <script type="text/javascript">
        var parent_elem = jQuery('.nav-tabs');
        var elem = jQuery('<li class="nav-item">').html('<a class="nav-link" id="agentDetailsTab" data-toggle="tab" href="#agentDetailsTabContent" role="tab" aria-controls="agentDetailsTabContent" aria-expanded="true" aria-selected="false">Pickup Address(<span class="count">1</span>)</a>');

        var elem1 = jQuery('#extraTabPickup');
        jQuery('#orderReturnsTabContent').after(elem1.html());

		parent_elem.append(elem);
		jQuery('#extraTabPickup').remove();

        jQuery(document).ready(function() {
            var labels_html = jQuery('.smartsend-label-buttons');
            jQuery('div#orderShippingTabContent').prepend(labels_html.html());
            jQuery('.smartsend-label-buttons').remove();
        });
    </script>
{/if}
