{*
* LICENSE
*
* This source file is subject to the GNU General Public License v3.0
* that is bundled with this package in the file license.txt.
* It is also available through the world-wide-web at this URL:
* http://www.gnu.org/licenses/gpl-3.0.html
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@smartsend.io so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade the plugin to newer
* versions in the future. If you wish to customize the plugin for your
* needs please refer to https://www.smartsend.io
*
* @author 		Smart Send ApS
* @copyright	Copyright (c) Smart Send ApS (https://www.smartsend.io)
* @license		https://smartsend.io/license
* @url			https://smartsend.io/
* @folder		smart_send_shipping/views/templates/hook/label_buttons.tpl
*
*}

<div class="smartsend-label-buttons">
    {if !$live_mode}
        <a class="btn btn-primary"   href="{$request_uri|escape:'html':'UTF-8'}&smartsend_action=generate_label" alt="{l s='DEMO: Generate label' mod='smartsend'}"><i class="icon-print"></i> {l s='DEMO: Generate label' mod='smartsend'}</a>
        <a class="btn btn-primary"   href="{$request_uri|escape:'html':'UTF-8'}&smartsend_action=generate_return_label" alt="{l s='DEMO: Generate return label' mod='smartsend'}"><i class="icon-print"></i> {l s='DEMO: Generate return label' mod='smartsend'}</a>
    {else}
        <a class="btn btn-primary"   href="{$request_uri|escape:'html':'UTF-8'}&smartsend_action=generate_label" alt="{l s='Generate label' mod='smartsend'}"><i class="icon-print"></i> {l s='Generate label' mod='smartsend'}</a>
        <a class="btn btn-primary"   href="{$request_uri|escape:'html':'UTF-8'}&smartsend_action=generate_return_label" alt="{l s='Generate return label' mod='smartsend'}"><i class="icon-print"></i> {l s='Generate return label' mod='smartsend'}</a>
    {/if}
    <br><br>
    {if isset($label_pdf_link) && $label_pdf_link}
        <a class="btn btn-primary" target="_blank"  href="{$label_pdf_link|escape:'html':'UTF-8'}" alt="{l s='Download Shipping Label' mod='smartsend'}"><i class="icon-download"></i> {l s='Download Shipping Label' mod='smartsend'}</a>
    {/if}
    {if isset($return_label_pdf_link) && $return_label_pdf_link}
        <a class="btn btn-primary" target="_blank"  href="{$return_label_pdf_link|escape:'html':'UTF-8'}" alt="{l s='Download Return Shipping Label' mod='smartsend'}"><i class="icon-download"></i> {l s='Download Return Shipping Label' mod='smartsend'}</a>
    {/if}
    {if isset($tracking_url) && $tracking_url}
        <a class="btn btn-primary" target="_blank"  href="{$tracking_url|escape:'html':'UTF-8'}" alt="{l s='Track Shipment' mod='smartsend'}"><i class="icon-truck"></i> {l s='Track Shipment' mod='smartsend'}</a>
    {/if}
</div>

{if $is_order_page!=''}
    <script type="text/javascript">

        var elems_count = jQuery(".smartsend-label-buttons a").length;
        counting=0;

        jQuery(".smartsend-label-buttons a").each(function() {
            counting=counting+1;

            jQuery(this).removeAttr('class');
            jQuery('#form-order').children('.panel').find('div.bulk-actions').find('ul.dropdown-menu').find('li.divider').siblings("li").eq(counting).after("<li class='smartsend_buttons'>"+jQuery(this).prop('outerHTML')+"</li>");
            if (counting==elems_count) {
                jQuery('#form-order').children('.panel').find('div.bulk-actions').find('ul.dropdown-menu').find('li.divider').siblings("li").eq(counting-2).after("<li class='divider'></li>");
            }
        });
        jQuery(".smartsend-label-buttons").remove();

    jQuery('li.smartsend_buttons a').on('click',function(event) {
        event.preventDefault();
	form= jQuery(this).closest('form').get(0);

	var form_action = jQuery(this).attr('href');

	if (form_action.replace(/(?:(?:^|\n)\s+|\s+(?:$|\n))/g,'').replace(/\s+/g,' ') == '')
		return false;




	jQuery(form).attr('action', form_action);
	jQuery(form).submit();

    });

	jQuery( document ).ready(function() {
		var uri = '{$request_uri|escape:"html":"UTF-8"}';

		jQuery('.dropdown-menu').append('<a id="order_grid_bulk_action_generate_label" class="dropdown-item generate_label" type="button" href="javascript:;">Generate Labels</a><form id="bulk_action_generate_label_form" class="bulk_action_generate_label" name="bulk_action_generate_label_form" action="'+uri+'" method="post"></form>');

		jQuery('.dropdown-menu').append('<a id="order_grid_bulk_action_generate_return_label" class="dropdown-item generate_return_label" type="button" href="javascript:;">Generate Return Labels</a><form id="bulk_action_generate_return_label_form" class="bulk_action_generate_label" name="bulk_action_generate_return_label_form" action="'+uri+'" method="post"></form>');

		jQuery('.js-bulk-action-checkbox').click(function () {
			jQuery('input[name="order_orders_bulk[]"]').each(function(){
				if( jQuery(this).is(':checked')){
					if(jQuery('#orderId' + jQuery(this).attr("value")).val() > 0) {
						//continue;
					} else {
						jQuery('.bulk_action_generate_label').append('<input id="orderId'+jQuery(this).attr("value")+'" type="hidden" name="orderIds[]" value="'+jQuery(this).attr("value")+'" />');
					}
				} else {
					jQuery('.bulk_action_generate_label #orderId'+jQuery(this).attr("value")).remove();
				}
			});
		});

		//Submit bulk action
		jQuery('.generate_label').click(function () {
			generate_label = jQuery('#bulk_action_generate_label_form');
			jQuery(generate_label).attr('action', uri+'&smartsend_action=generate_label');
			jQuery(generate_label).submit();
		});

		jQuery('.generate_return_label').click(function () {
			return_label = jQuery('#bulk_action_generate_return_label_form');
			jQuery(return_label).attr('action', uri+'&smartsend_action=generate_return_label');
			jQuery(return_label).submit();
		});

    });

    </script>
{/if}
